/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.multicast;

import infoservice.agreement.common.FifoQueue;
import infoservice.agreement.multicast.AbstractEMCAdapter;
import infoservice.agreement.multicast.messages.RawMessage;

public class MessageHandlerThread
extends Thread {
    private boolean m_bRunning = true;
    private AbstractEMCAdapter m_agreementHandler = null;
    private FifoQueue m_queue = null;

    public MessageHandlerThread(AbstractEMCAdapter a_handler, FifoQueue a_queue) {
        super("infoservice.agreement.multicast.MessageHandlerThread");
        this.m_agreementHandler = a_handler;
        this.m_queue = a_queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.m_bRunning) {
            RawMessage msg = null;
            FifoQueue fifoQueue = this.m_queue;
            synchronized (fifoQueue) {
                msg = (RawMessage)this.m_queue.pop();
            }
            while (msg != null) {
                this.m_agreementHandler.handleMessage(msg.getAgreementMessage());
                fifoQueue = this.m_queue;
                synchronized (fifoQueue) {
                    msg = (RawMessage)this.m_queue.pop();
                }
            }
            fifoQueue = this.m_queue;
            synchronized (fifoQueue) {
                try {
                    this.m_queue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void setRunning(boolean a_bRunning) {
        this.m_bRunning = a_bRunning;
    }
}

