/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.infoservice.ListenerInterface;
import anon.util.SocketGuard;
import infoservice.ISRuntimeStatistics;
import infoservice.InfoService;
import infoservice.InfoServiceConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import logging.LogHolder;
import logging.LogType;

final class InfoServiceServer
implements Runnable {
    private static final int GUARD_TIMEOUT_IN_MS = 120000;
    private ListenerInterface m_Listener;
    private InfoService m_IS;

    public InfoServiceServer(ListenerInterface listener, InfoService is) {
        this.m_Listener = listener;
        this.m_IS = is;
    }

    @Override
    public void run() {
        String strInterface = this.m_Listener.getHost();
        LogHolder.log(1, LogType.ALL, "Server on interface: " + strInterface + " on port: " + this.m_Listener.getPort() + " starting...");
        ServerSocket server = null;
        SocketGuard socket = null;
        try {
            server = new ServerSocket(this.m_Listener.getPort(), 200, InetAddress.getByName(this.m_Listener.getHost()));
            LogHolder.log(6, LogType.NET, "ServerSocket is listening!");
            while (true) {
                try {
                    socket = null;
                    socket = new SocketGuard(server.accept(), 120000L);
                }
                catch (IOException ioe) {
                    LogHolder.log(2, LogType.NET, "Accept-Exception: " + ioe);
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!ioe.getMessage().equalsIgnoreCase("Too many open files")) continue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                ++ISRuntimeStatistics.ms_lTCPIPConnections;
                try {
                    InfoServiceConnection doIt = new InfoServiceConnection(socket, InfoService.getConnectionCounter(), this.m_IS.oicHandler);
                    this.m_IS.m_ThreadPool.addRequest(doIt);
                    doIt = null;
                }
                catch (Exception e2) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        socket = null;
                    }
                    LogHolder.log(2, LogType.MISC, "Run-Loop-Exception: " + e2);
                }
            }
        }
        catch (Throwable t) {
            LogHolder.log(1, LogType.MISC, "Unexcpected Exception in Run-Loop (exiting): " + t);
            try {
                if (socket != null) {
                    socket.close();
                }
                server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LogHolder.log(3, LogType.NET, "JWS Exception: " + t);
            LogHolder.log(1, LogType.NET, "Server on interface: " + strInterface + " on port: " + this.m_Listener.getPort());
            LogHolder.log(0, LogType.NET, "Exiting because of fatal Error!");
            return;
        }
    }

    public String toString() {
        String s = "InfoService Server on Interface: ";
        s = this.m_Listener == null ? s + "unknown" : s + this.m_Listener.getHost() + ":" + this.m_Listener.getPort();
        return s;
    }
}

