/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.crypto.SignatureCreator;
import anon.crypto.XMLSignature;
import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.AbstractDistributableDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.HttpResponseStructure;
import anon.infoservice.IBoostrapable;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import anon.util.ZLibTools;
import infoservice.Configuration;
import java.util.Enumeration;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class HTTPResponseGetter {
    private static final long CACHE_SERIALS_MS = 10000L;
    private static final long CACHE_MS = 10000L;
    private HttpResponseStructure m_cachedSerialsResponse;
    private HttpResponseStructure m_cachedSerialsCompressedResponse;
    private final Object SYNC_CACHE_SERIALS = new Object();
    private long m_lastSerialsUpdate = 0L;
    private HttpResponseStructure m_cachedResponse;
    private HttpResponseStructure m_cachedCompressedResponse;
    private final Object SYNC_CACHE = new Object();
    private long m_lastUpdate = 0L;
    private boolean m_bWebInfo;

    public HTTPResponseGetter() {
    }

    public HTTPResponseGetter(boolean a_bWebInfo) {
        this.m_bWebInfo = a_bWebInfo;
    }

    public abstract Class<? extends AbstractDatabaseEntry> getDatabaseClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponseStructure fetchResponse(int a_supportedEncodings) {
        Object object = this.SYNC_CACHE;
        synchronized (object) {
            if (this.m_lastUpdate < System.currentTimeMillis() - 10000L) {
                Document doc;
                this.m_lastUpdate = System.currentTimeMillis();
                if (this.m_bWebInfo) {
                    doc = Database.getInstance(this.getDatabaseClass()).getWebInfos();
                } else {
                    doc = XMLUtil.createDocument();
                    Element containerNode = doc.createElement(XMLUtil.getXmlElementContainerName(this.getDatabaseClass()));
                    XMLUtil.setAttribute(containerNode, "id", Configuration.getInstance().getID());
                    XMLUtil.setAttribute(containerNode, "lastUpdate", this.m_lastUpdate);
                    Enumeration knownentries = Database.getInstance(this.getDatabaseClass()).getEntrySnapshotAsEnumeration();
                    while (knownentries.hasMoreElements()) {
                        IXMLEncodable currentCascade = (IXMLEncodable)knownentries.nextElement();
                        if (currentCascade instanceof IBoostrapable && ((IBoostrapable)((Object)currentCascade)).isBootstrap()) continue;
                        Element node = currentCascade.toXmlElement(doc);
                        containerNode.appendChild(node);
                    }
                    SignatureCreator.getInstance().signXml(2, containerNode);
                    doc.appendChild(containerNode);
                }
                try {
                    this.m_cachedCompressedResponse = new HttpResponseStructure(2, 1, ZLibTools.compress(XMLUtil.toByteArray(doc)));
                }
                catch (Exception ex) {
                    this.m_cachedCompressedResponse = new HttpResponseStructure(500);
                }
                this.m_cachedResponse = new HttpResponseStructure(doc);
            }
        }
        HttpResponseStructure httpResponse = (a_supportedEncodings & 1) > 0 ? this.m_cachedCompressedResponse : this.m_cachedResponse;
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponseStructure fetchSerialsResponse(int a_supportedEncodings) {
        Object object = this.SYNC_CACHE_SERIALS;
        synchronized (object) {
            if (this.m_lastSerialsUpdate < System.currentTimeMillis() - 10000L) {
                Document doc = XMLUtil.createDocument();
                Element node = new AbstractDistributableDatabaseEntry.Serials(this.getDatabaseClass()).toXmlElement(doc);
                SignatureCreator.getInstance().signXml(2, node);
                doc.appendChild(node);
                try {
                    this.m_cachedSerialsCompressedResponse = new HttpResponseStructure(2, 1, ZLibTools.compress(XMLSignature.toCanonical(doc)));
                }
                catch (XMLParseException ex) {
                    this.m_cachedCompressedResponse = new HttpResponseStructure(500);
                }
                this.m_cachedSerialsResponse = new HttpResponseStructure(doc);
                this.m_lastSerialsUpdate = System.currentTimeMillis();
            }
        }
        HttpResponseStructure httpResponse = (a_supportedEncodings & 1) > 0 ? this.m_cachedSerialsCompressedResponse : this.m_cachedSerialsResponse;
        return httpResponse;
    }

    public HttpResponseStructure fetchResponse(int a_supportedEncodings, boolean a_bSerialsOnly) {
        HttpResponseStructure httpResponse;
        try {
            httpResponse = a_bSerialsOnly ? this.fetchSerialsResponse(a_supportedEncodings) : this.fetchResponse(a_supportedEncodings);
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.NET, e);
        }
        return httpResponse;
    }
}

