/*
 * Decompiled with CFR 0.152.
 */
package captcha.graphics;

import captcha.graphics.RgbMemoryImageConsumer;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.lang.reflect.Field;
import logging.LogHolder;
import logging.LogType;

public class ImageFactory {
    public static Image createImage(int a_width, int a_height) {
        Image returnImage = null;
        try {
            Class<?> bufferedImageClass = Class.forName("java.awt.image.BufferedImage");
            Class[] bufferedImageConstructorParamTypes = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Field argbImageType = bufferedImageClass.getField("TYPE_INT_ARGB");
            Object[] bufferedImageConstructorParams = new Object[]{new Integer(a_width), new Integer(a_height), new Integer(argbImageType.getInt(bufferedImageClass))};
            returnImage = (Image)bufferedImageClass.getConstructor(bufferedImageConstructorParamTypes).newInstance(bufferedImageConstructorParams);
        }
        catch (Exception e) {
            LogHolder.log(0, LogType.MISC, "Error while creating empty Image: " + e.toString());
        }
        return returnImage;
    }

    public static Image createImage(ImageProducer a_imageProducer) {
        Image returnImage = null;
        try {
            RgbMemoryImageConsumer memoryImage = new RgbMemoryImageConsumer(a_imageProducer);
            returnImage = ImageFactory.createImage(memoryImage.getWidth(), memoryImage.getHeight());
            Class<?> bufferedImageClass = Class.forName("java.awt.image.BufferedImage");
            Class[] bufferedImageSetRgbParamTypes = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class, Integer.TYPE, Integer.TYPE};
            Object[] setRgbParams = new Object[]{new Integer(0), new Integer(0), new Integer(memoryImage.getWidth()), new Integer(memoryImage.getHeight()), memoryImage.getRgbPixels(), new Integer(0), new Integer(memoryImage.getWidth())};
            bufferedImageClass.getMethod("setRGB", bufferedImageSetRgbParamTypes).invoke((Object)returnImage, setRgbParams);
        }
        catch (Exception e) {
            LogHolder.log(0, LogType.MISC, "Error while creating Image from ImageProducer: " + e.toString());
            returnImage = null;
        }
        return returnImage;
    }
}

