/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.platform.AbstractOS;
import anon.util.IReturnRunnable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class SocketGuard {
    private Thread m_threadCloseGuard = null;
    private Object SYNC_CLOSE = new Object();
    private Socket m_Socket;
    private InputStream m_istream;
    private OutputStream m_ostream;
    private String m_strCaller;
    static /* synthetic */ Class class$java$net$Socket;

    public SocketGuard(Socket socket, final long a_forceCloseAfterMS) throws IOException {
        this.m_Socket = socket;
        this.m_strCaller = LogHolder.getCallingMethod(true);
        if (a_forceCloseAfterMS > 0L && SocketGuard.isClosedSupported()) {
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = SocketGuard.this.SYNC_CLOSE;
                    synchronized (object) {
                        if (SocketGuard.this.m_threadCloseGuard != null) {
                            LogHolder.log(7, LogType.NET, "Waiting for socket for " + a_forceCloseAfterMS + " milliseconds...");
                            try {
                                SocketGuard.this.SYNC_CLOSE.wait(a_forceCloseAfterMS);
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                            if (!SocketGuard.isClosed(SocketGuard.this.m_Socket)) {
                                LogHolder.log(1, LogType.NET, "Closing socket after " + a_forceCloseAfterMS + " milliseconds! Called from: " + SocketGuard.this.m_strCaller);
                                try {
                                    SocketGuard.this.close();
                                }
                                catch (IOException ex1) {
                                    LogHolder.log(1, LogType.NET, ex1);
                                }
                                if (!SocketGuard.isClosed(SocketGuard.this.m_Socket)) {
                                    LogHolder.log(1, LogType.NET, "Unable to close socket!! This is a serious problem. Called from: " + SocketGuard.this.m_strCaller);
                                }
                            }
                        }
                    }
                }
            };
            this.m_threadCloseGuard = new Thread(run);
            this.m_threadCloseGuard.start();
        }
        this.m_istream = socket.getInputStream();
        this.m_ostream = socket.getOutputStream();
    }

    public Socket getSocket() {
        return this.m_Socket;
    }

    public InetAddress getInetAddress() {
        return this.m_Socket.getInetAddress();
    }

    public InputStream getInputStream() {
        return this.m_istream;
    }

    public OutputStream getOutputStream() {
        return this.m_ostream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        IOException ex;
        block13: {
            block12: {
                ex = null;
                try {
                    if (this.m_ostream != null) {
                        this.m_ostream.close();
                    }
                }
                catch (IOException a_e) {
                    if (ex != null) break block12;
                    ex = a_e;
                }
            }
            try {
                if (this.m_istream != null) {
                    this.m_istream.close();
                }
            }
            catch (IOException a_e) {
                if (ex != null) break block13;
                ex = a_e;
            }
        }
        if (this.m_Socket != null) {
            this.m_Socket.close();
        }
        if (this.m_threadCloseGuard != null) {
            Object object = this.SYNC_CLOSE;
            synchronized (object) {
                this.SYNC_CLOSE.notify();
                this.m_threadCloseGuard = null;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static void close(SocketGuard a_socket) {
        if (a_socket != null) {
            try {
                a_socket.close();
            }
            catch (IOException ex1) {
                LogHolder.log(3, LogType.NET, ex1);
            }
        }
    }

    public boolean isClosed() {
        return SocketGuard.isClosed(this.m_Socket);
    }

    public void setSoTimeout(int ms) throws SocketException {
        if (this.m_Socket != null) {
            this.m_Socket.setSoTimeout(ms);
        }
    }

    public static boolean isClosedSupported() {
        try {
            (class$java$net$Socket == null ? (class$java$net$Socket = SocketGuard.class$("java.net.Socket")) : class$java$net$Socket).getMethod("isClosed", new Class[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void close(final Socket a_socket) throws IOException {
        if (a_socket == null) {
            return;
        }
        IReturnRunnable run = new IReturnRunnable(){
            IOException ex = null;

            public void run() {
                do {
                    boolean bIsClosed = SocketGuard.isClosed(a_socket);
                    try {
                        a_socket.getInputStream().close();
                    }
                    catch (Exception a_e) {
                        // empty catch block
                    }
                    try {
                        a_socket.getOutputStream().close();
                    }
                    catch (Exception a_e) {
                        // empty catch block
                    }
                    try {
                        a_socket.close();
                        Thread.yield();
                    }
                    catch (IOException a_e) {
                        this.ex = a_e;
                        if (bIsClosed || SocketGuard.isClosedSupported()) continue;
                        LogHolder.log(4, LogType.NET, a_e);
                    }
                } while (SocketGuard.isClosedSupported() && !SocketGuard.isClosed(a_socket));
            }

            public Object getValue() {
                return this.ex;
            }
        };
        Thread tRun = new Thread(run);
        tRun.start();
        do {
            try {
                tRun.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (tRun.isAlive());
        if (run.getValue() != null && !SocketGuard.isClosedSupported()) {
            throw (IOException)run.getValue();
        }
    }

    public static boolean isClosed(Socket a_socket) {
        Socket socket = a_socket;
        if (socket != null) {
            try {
                return (Boolean)(class$java$net$Socket == null ? (class$java$net$Socket = SocketGuard.class$("java.net.Socket")) : class$java$net$Socket).getMethod("isClosed", new Class[0]).invoke((Object)socket, new Object[0]);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Socket createSocket(final String a_hostName, final int a_port, long a_createTimeout) throws Exception {
        final Vector socketStore = new Vector();
        final Vector exceptionStore = new Vector();
        Thread createThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Socket serverConnection = new Socket(a_hostName, a_port);
                    Vector vector = socketStore;
                    synchronized (vector) {
                        if (Thread.interrupted()) {
                            serverConnection.close();
                        } else {
                            socketStore.addElement(serverConnection);
                        }
                    }
                }
                catch (Exception e) {
                    Vector vector = exceptionStore;
                    synchronized (vector) {
                        exceptionStore.addElement(e);
                    }
                }
            }
        });
        createThread.setDaemon(true);
        createThread.start();
        try {
            createThread.join(a_createTimeout);
        }
        catch (Exception e) {
            createThread.interrupt();
            Vector vector = socketStore;
            synchronized (vector) {
                if (socketStore.size() > 0) {
                    try {
                        ((Socket)socketStore.firstElement()).close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
            throw e;
        }
        Socket createdSocket = null;
        Vector vector = socketStore;
        synchronized (vector) {
            Vector vector2 = exceptionStore;
            synchronized (vector2) {
                if (exceptionStore.size() > 0) {
                    throw (Exception)exceptionStore.firstElement();
                }
                if (socketStore.size() <= 0) {
                    createThread.interrupt();
                    throw new Exception("Timeout occured while creating socket.");
                }
                createdSocket = (Socket)socketStore.firstElement();
            }
        }
        return createdSocket;
    }

    public static ServerSocket createVirtualBoxServerSocket(int a_port, InetAddress a_excludeAddress) {
        InetAddress address;
        Enumeration enumInterfaces;
        Method method;
        Class<?> classInet6Address;
        Class<?> classNetworkInterface;
        ServerSocket socketListener = null;
        try {
            classNetworkInterface = Class.forName("java.net.NetworkInterface");
            classInet6Address = Class.forName("java.net.Inet6Address");
            method = classNetworkInterface.getMethod("getNetworkInterfaces", null);
            enumInterfaces = (Enumeration)method.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            LogHolder.log(1, LogType.NET, "Could not get any network interfaces!", e);
            return null;
        }
        InetAddress ipv6Address = null;
        block8: while (enumInterfaces != null && enumInterfaces.hasMoreElements() && socketListener == null) {
            Enumeration enumInetAddress;
            Object netInterface = enumInterfaces.nextElement();
            if (!AbstractOS.getInstance().isVirtualBoxInterface(netInterface)) continue;
            try {
                method = classNetworkInterface.getMethod("getInetAddresses", null);
                enumInetAddress = (Enumeration)method.invoke(netInterface, (Object[])null);
            }
            catch (Exception a_e) {
                LogHolder.log(1, LogType.NET, "Could not analyze network interfaces!", a_e);
                return null;
            }
            while (enumInetAddress.hasMoreElements()) {
                address = (InetAddress)enumInetAddress.nextElement();
                if (classInet6Address.isInstance(address)) {
                    if (ipv6Address != null) continue;
                    ipv6Address = address;
                    continue;
                }
                if (a_excludeAddress.equals(address)) {
                    enumInterfaces = null;
                    continue block8;
                }
                LogHolder.log(5, LogType.NET, "Try binding Listener on host: " + address);
                try {
                    socketListener = new ServerSocket(a_port, 50, address);
                    LogHolder.log(1, LogType.NET, "Listener was successfully bound to: " + address.getHostAddress() + ":" + a_port);
                    continue block8;
                }
                catch (IOException a_e) {
                    LogHolder.log(4, LogType.NET, "Could not bind listener to host: " + address, a_e);
                }
            }
        }
        if (socketListener == null && ipv6Address != null) {
            address = ipv6Address;
            try {
                socketListener = new ServerSocket(a_port, 50, address);
                LogHolder.log(1, LogType.NET, "Listener was successfully bound to: " + socketListener);
            }
            catch (IOException a_e) {
                LogHolder.log(4, LogType.NET, "Could not bind listener to host: " + address, a_e);
            }
        }
        return socketListener;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

