/*
 * Decompiled with CFR 0.152.
 */
package anon.terms;

import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.w3c.dom.Node;

public class TermsAndConditionsMixInfo {
    public static final String TNC_MIX_INFO_ROOT = "TermsAndConditionsInfos";
    public static final String TNC_MIX_INFO = "TermsAndConditionsInfo";
    public static final String TNC_MIX_INFO_ID = "id";
    public static final String TNC_MIX_INFO_DATE = "date";
    public static final String TNC_MIX_INFO_LOCALE = "locale";
    public static final String TNC_MIX_INFO_DEFAULT_LANG = "defaultLang";
    public static final String TNC_MIX_INFO_TEMPLATE_REFID = "referenceId";
    private String id = "";
    private String date = "";
    private String defaultLang = "";
    private Hashtable templates = new Hashtable();

    public TermsAndConditionsMixInfo(Node infoRoot) throws XMLParseException {
        if (infoRoot == null) {
            throw new XMLParseException("T&C Info Node is null");
        }
        this.id = XMLUtil.parseAttribute(infoRoot, TNC_MIX_INFO_ID, "");
        if (this.id.equals("")) {
            throw new XMLParseException("T&C Info Node does not contain an ID");
        }
        this.date = XMLUtil.parseAttribute(infoRoot, TNC_MIX_INFO_DATE, "");
        if (this.date.equals("")) {
            throw new XMLParseException("T&C Info Node " + this.id + " does not contain a valid date");
        }
        this.defaultLang = XMLUtil.parseAttribute(infoRoot, TNC_MIX_INFO_DEFAULT_LANG, "").trim().toLowerCase();
        if (this.defaultLang.equals("")) {
            throw new XMLParseException("T&C Info Node " + this.id + " does not define a default language");
        }
        Node it = XMLUtil.getFirstChildByName(infoRoot, TNC_MIX_INFO);
        String currentInfoLang = "";
        String currentInfoTemplateRefId = "";
        while (it != null) {
            currentInfoLang = XMLUtil.parseAttribute(it, TNC_MIX_INFO_LOCALE, "");
            currentInfoTemplateRefId = XMLUtil.parseAttribute(it, TNC_MIX_INFO_TEMPLATE_REFID, "");
            if (!currentInfoLang.equals("") && !currentInfoTemplateRefId.equals("")) {
                this.templates.put(currentInfoLang.trim().toLowerCase(), currentInfoTemplateRefId);
            }
            it = XMLUtil.getNextSiblingByName(it, TNC_MIX_INFO);
        }
        Enumeration e = this.getLanguages();
    }

    public String getId() {
        return this.id;
    }

    public String getDate() {
        return this.date;
    }

    public String getTemplateRefId(Locale locale) {
        return this.getTemplateRefId(locale.getLanguage());
    }

    public String getTemplateRefId(String langCode) {
        return (String)this.templates.get(langCode.trim().toLowerCase());
    }

    public String getDefaultTemplateRefId() {
        return (String)this.templates.get(this.getDefaultLanguage());
    }

    public boolean hasTranslation(String langCode) {
        return this.templates.get(langCode.trim().toLowerCase()) != null;
    }

    public boolean hasTranslation(Locale locale) {
        return this.hasTranslation(locale.getLanguage());
    }

    public String getDefaultLanguage() {
        return this.defaultLang;
    }

    public Enumeration getLanguages() {
        return this.templates.keys();
    }
}

