/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.pay.PayAccountsFile;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPassivePayment
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "PassivePayment";
    private static final String XML_DOCUMENT_VERSION = "1.0";
    private static final String VERSION = "version";
    private static final String TRANSFER_NUM = "TransferNumber";
    private static final String AMOUNT = "Amount";
    private static final String CURRENCY = "Currency";
    private static final String CHARGED = "Charged";
    private static final String PAYMENT_DATA = "PaymentData";
    private static final String REF = "ref";
    private static final String PAYMENT_NAME = "PaymentName";
    private static final String ERRORCODE = "ErrorCode";
    private static final String ERRORMSG = "ErrorMessage";
    private static final String IP = "IPAdress";
    private Hashtable m_paymentData = new Hashtable();
    private long m_transferNumber;
    private String m_currency;
    private long m_centAmount;
    private String m_paymentName;
    private boolean m_charged;
    private String m_sErrorCode = "";
    private String m_sErrorMessage = "";
    private String m_sIP = "";
    private String m_strAffiliate;
    public static final String KEY_COUPONCODE = "code";
    public static final String KEY_ACCOUNTNUMBER = "accountnumber";
    public static final String KEY_TRANSFERNUMBER = "transfernumber";
    public static final String KEY_VOLUMEPLAN = "volumeplan";
    public static final String KEY_MERCHANT_ID = "merchant_id";
    public static final String KEY_TRANSACTION_ID = "transaction_id";
    public static final String KEY_ERRORCODE = "errorcode";
    public static final String KEY_ERRORMESSAGE = "errormessage";
    public static final String KEY_IPADRESS = "IPAdress";

    public XMLPassivePayment(String a_piid) {
        this.m_strAffiliate = PayAccountsFile.getInstance().getAffiliate(a_piid, false);
    }

    public XMLPassivePayment(Element element) throws XMLParseException {
        this.setValues(element);
    }

    private void setValues(Element elemRoot) throws XMLParseException {
        if (!elemRoot.getTagName().equals(XML_ELEMENT_NAME) || !elemRoot.getAttribute(VERSION).equals(XML_DOCUMENT_VERSION)) {
            throw new XMLParseException("PassivePayment wrong format or wrong version number");
        }
        this.m_paymentData = new Hashtable();
        NodeList nodesData = elemRoot.getElementsByTagName(PAYMENT_DATA);
        for (int i = 0; i < nodesData.getLength(); ++i) {
            String ref = XMLUtil.parseAttribute(nodesData.item(i), REF, null);
            String value = XMLUtil.parseValue(nodesData.item(i), null);
            this.m_paymentData.put(ref, value);
        }
        this.m_transferNumber = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, TRANSFER_NUM), 0L);
        this.m_centAmount = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, AMOUNT), 0L);
        this.m_currency = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, CURRENCY), null);
        this.m_paymentName = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, PAYMENT_NAME), null);
        this.m_charged = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, CHARGED), false);
        this.m_sErrorCode = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, ERRORCODE), "0");
        this.m_sErrorMessage = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, ERRORMSG), "");
        this.m_strAffiliate = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, "Affiliate"), null);
    }

    public String getAffiliate() {
        return this.m_strAffiliate;
    }

    public void setIP(String a_sIP) {
        this.m_sIP = a_sIP;
    }

    public String getIP() {
        return this.m_sIP;
    }

    public void setErrorMessage(String a_sErrorMessage) {
        this.m_sErrorMessage = a_sErrorMessage;
    }

    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    public void setErrorCode(String a_sErrorCode) {
        this.m_sErrorCode = a_sErrorCode;
    }

    public String getErrorCode() {
        return this.m_sErrorCode;
    }

    public void setPaymentName(String a_paymentName) {
        this.m_paymentName = a_paymentName;
    }

    public String getPaymentName() {
        return this.m_paymentName;
    }

    public void setAmount(long a_amount) {
        this.m_centAmount = a_amount;
    }

    public void setCurrency(String a_currency) {
        this.m_currency = a_currency;
    }

    public void setCharged(boolean charged) {
        this.m_charged = charged;
    }

    public void setTransferNumber(long a_transferNumber) {
        this.m_transferNumber = a_transferNumber;
    }

    public void addData(String a_reference, String a_data) {
        this.m_paymentData.put(a_reference, a_data);
    }

    public long getAmount() {
        return this.m_centAmount;
    }

    public long getTransferNumber() {
        return this.m_transferNumber;
    }

    public String getCurrency() {
        return this.m_currency;
    }

    public boolean isCharged() {
        return this.m_charged;
    }

    public Enumeration getReferences() {
        return this.m_paymentData.keys();
    }

    public String getPaymentData(String a_key) {
        return (String)this.m_paymentData.get(a_key);
    }

    public String getAllPaymentData() {
        String data = "";
        Enumeration e = this.m_paymentData.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            data = data + key + " = " + (String)this.m_paymentData.get(key);
            if (!e.hasMoreElements()) continue;
            data = data + "\n";
        }
        return data;
    }

    public Enumeration getPaymentDataKeys() {
        return this.m_paymentData.keys();
    }

    public Element toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(XML_ELEMENT_NAME);
        elemRoot.setAttribute(VERSION, XML_DOCUMENT_VERSION);
        Element elem = a_doc.createElement(TRANSFER_NUM);
        XMLUtil.setValue((Node)elem, this.m_transferNumber);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(PAYMENT_NAME);
        XMLUtil.setValue((Node)elem, this.m_paymentName);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(AMOUNT);
        XMLUtil.setValue((Node)elem, String.valueOf(this.m_centAmount));
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(CURRENCY);
        XMLUtil.setValue((Node)elem, this.m_currency);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(CHARGED);
        XMLUtil.setValue((Node)elem, this.m_charged);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(ERRORCODE);
        XMLUtil.setValue((Node)elem, this.m_sErrorCode);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(ERRORMSG);
        XMLUtil.setValue((Node)elem, this.m_sErrorMessage);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("IPAdress");
        XMLUtil.setValue((Node)elem, this.m_sIP);
        elemRoot.appendChild(elem);
        if (this.m_strAffiliate != null) {
            elem = a_doc.createElement("Affiliate");
            XMLUtil.setValue((Node)elem, this.m_strAffiliate);
            elemRoot.appendChild(elem);
        }
        Enumeration refs = this.m_paymentData.keys();
        while (refs.hasMoreElements()) {
            String ref = (String)refs.nextElement();
            elem = a_doc.createElement(PAYMENT_DATA);
            XMLUtil.setAttribute(elem, REF, ref);
            XMLUtil.setValue((Node)elem, (String)this.m_paymentData.get(ref));
            elemRoot.appendChild(elem);
        }
        return elemRoot;
    }
}

