/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.crypto.MyRSA;
import anon.crypto.MyRSAPublicKey;
import anon.mixminion.message.ExitInformation;
import anon.mixminion.message.ForwardInformation;
import anon.mixminion.message.MixMinionCryptoUtil;
import anon.mixminion.message.RoutingInformation;
import anon.mixminion.mmrdescription.MMRDescription;
import anon.util.ByteArrayUtil;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class Header {
    private final int HEADER_LEN = 2048;
    private final int PK_ENC_LEN = 256;
    private final int PK_OVERHEAD_LEN = 42;
    private final int PK_MAX_DATA_LEN = 214;
    private final int HASH_LEN = 20;
    private final int MIN_SH = 42;
    private byte[] VERSION_MAJOR = new byte[]{0, 3};
    private byte[] m_header;

    public Header(Vector path, Vector secrets, ExitInformation exitInfo) {
        this.m_header = this.buildHeader(path, secrets, exitInfo);
    }

    private byte[] buildHeader(Vector path, Vector secrets, ExitInformation exitInfo) {
        Vector<RoutingInformation> routingInformation = new Vector<RoutingInformation>();
        Vector<MyRSAPublicKey> publicKey = new Vector<MyRSAPublicKey>();
        Vector<byte[]> junkKeys = new Vector<byte[]>();
        Vector<byte[]> subSecret = new Vector<byte[]>();
        int internodes = path.size();
        int[] size = new int[internodes + 1];
        publicKey.addElement(null);
        routingInformation.addElement(null);
        junkKeys.addElement(null);
        subSecret.addElement(null);
        for (int i = 1; i <= internodes; ++i) {
            MMRDescription mmdescr = (MMRDescription)path.elementAt(i - 1);
            publicKey.addElement(mmdescr.getPacketKey());
            junkKeys.addElement(this.subKey((byte[])secrets.elementAt(i - 1), "RANDOM JUNK"));
            subSecret.addElement(this.subKey((byte[])secrets.elementAt(i - 1), "HEADER SECRET KEY"));
            RoutingInformation ri = mmdescr.getRoutingInformation();
            routingInformation.addElement(ri);
        }
        int totalsize = 0;
        for (int i = 1; i <= internodes; ++i) {
            size[i] = i == internodes ? exitInfo.m_Content.length : ((RoutingInformation)routingInformation.elementAt((int)(i + 1))).m_Content.length;
            int n = i;
            size[n] = size[n] + 84;
            totalsize += size[i];
        }
        int paddingLen = 2048 - totalsize;
        if (totalsize > 2048) {
            LogHolder.log(3, LogType.MISC, "[Calculating HEADERSIZE]: Subheaders don't fit into HEADER_LEN ");
        }
        Vector<byte[]> junkSeen = new Vector<byte[]>();
        byte[] Stream_i = null;
        junkSeen.addElement("".getBytes());
        for (int i = 1; i <= internodes; ++i) {
            byte[] lastJunk = (byte[])junkSeen.elementAt(i - 1);
            byte[] J_i = ByteArrayUtil.conc(lastJunk, MixMinionCryptoUtil.createPRNG((byte[])junkKeys.elementAt(i), size[i]));
            Stream_i = MixMinionCryptoUtil.createPRNG((byte[])subSecret.elementAt(i), 2048 + size[i]);
            int offset = 1792 - lastJunk.length;
            junkSeen.addElement(MixMinionCryptoUtil.xor(J_i, ByteArrayUtil.copy(Stream_i, offset, J_i.length)));
        }
        Vector<byte[]> header = new Vector<byte[]>();
        header.setSize(internodes + 2);
        byte[] padding = MixMinionCryptoUtil.randomArray(paddingLen);
        header.setElementAt(padding, internodes + 1);
        for (int i = internodes; i >= 1; --i) {
            ForwardInformation ri = i == internodes ? exitInfo : (ForwardInformation)routingInformation.elementAt(i + 1);
            byte[] sh0 = this.makeSHS(this.VERSION_MAJOR, (byte[])secrets.elementAt(i - 1), new byte[20], ByteArrayUtil.inttobyte(ri.m_Content.length, 2), ri.m_Type, ri.m_Content);
            int sh_len = sh0.length;
            byte[] h0 = ByteArrayUtil.conc(sh0, (byte[])header.elementAt(i + 1));
            byte[] rest = ByteArrayUtil.copy(h0, 214, h0.length - 214);
            byte[] erest = MixMinionCryptoUtil.Encrypt((byte[])subSecret.elementAt(i), rest);
            byte[] digest = MixMinionCryptoUtil.hash(ByteArrayUtil.conc(erest, (byte[])junkSeen.elementAt(i - 1)));
            byte[] sh = this.makeSHS(this.VERSION_MAJOR, (byte[])secrets.elementAt(i - 1), digest, ByteArrayUtil.inttobyte(ri.m_Content.length, 2), ri.m_Type, ri.m_Content);
            int underflow = this.max(214 - sh_len, 0);
            byte[] rsa_part = ByteArrayUtil.conc(sh, ByteArrayUtil.copy(h0, 214 - underflow, underflow));
            byte[] esh = this.pk_encrypt((MyRSAPublicKey)publicKey.elementAt(i), rsa_part);
            header.setElementAt(ByteArrayUtil.conc(esh, erest), i);
        }
        return (byte[])header.elementAt(1);
    }

    public byte[] getAsByteArray() {
        return this.m_header;
    }

    private byte[] subKey(byte[] secretKey, String phrase) {
        return ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(secretKey, phrase.getBytes())), 0, 16);
    }

    private byte[] makeFSHS(byte[] v, byte[] sk, byte[] d, byte[] rs, short rt) {
        return ByteArrayUtil.conc(v, sk, d, rs, ByteArrayUtil.inttobyte(rt, 2));
    }

    private byte[] makeSHS(byte[] V, byte[] SK, byte[] D, byte[] RS, short RT, byte[] RI) {
        return ByteArrayUtil.conc(this.makeFSHS(V, SK, D, RS, RT), RI);
    }

    private int max(int first, int second) {
        if (first < second) {
            first = second;
        }
        return first;
    }

    private byte[] pk_encrypt(MyRSAPublicKey key, byte[] m) {
        byte[] sp = "He who would make his own liberty secure, must guard even his enemy from oppression.".getBytes();
        SHA1Digest digest = new SHA1Digest();
        digest.update(sp, 0, sp.length);
        MyRSA engine = new MyRSA(digest);
        try {
            engine.init(key);
            return engine.processBlockOAEP(m, 0, m.length);
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.CRYPTO, e);
            return null;
        }
    }
}

