/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice.externaldatabase.jdbc;

import anon.infoservice.externaldatabase.EDBException;
import anon.infoservice.externaldatabase.IEDBDatabase;
import anon.infoservice.externaldatabase.jdbc.EDBConfigurationJDBC;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class EDBDatabaseJDBC
implements IEDBDatabase {
    private EDBConfigurationJDBC m_dbConf;
    private Object SYNC_EXTERNAL_DATABASE;

    public EDBDatabaseJDBC(EDBConfigurationJDBC dbConf) {
        this.m_dbConf = dbConf;
        this.SYNC_EXTERNAL_DATABASE = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doVacuum() throws EDBException {
        block11: {
            Object object = this.SYNC_EXTERNAL_DATABASE;
            synchronized (object) {
                if (this.m_dbConf == null || this.m_dbConf.getDatabaseURL() == null) {
                    return;
                }
                Connection conn = null;
                conn = DriverManager.getConnection(this.m_dbConf.getDatabaseURL());
                conn.setAutoCommit(true);
                Statement stat = conn.createStatement();
                stat.executeUpdate("VACUUM;");
                Object var5_5 = null;
                try {
                    conn.close();
                }
                catch (SQLException a_e) {
                    LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                }
                break block11;
                {
                    catch (Exception a_e) {
                        throw new EDBException("Exception in doVacuum(): " + a_e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    try {
                        conn.close();
                    }
                    catch (SQLException a_e) {
                        LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                    }
                    throw throwable;
                }
            }
        }
    }

    public void testDB() throws Exception {
        Class.forName(this.m_dbConf.getDriverClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void insert(String type, String id, String content) throws EDBException {
        Object object = this.SYNC_EXTERNAL_DATABASE;
        synchronized (object) {
            block12: {
                Connection conn = null;
                conn = DriverManager.getConnection(this.m_dbConf.getDatabaseURL());
                conn.setAutoCommit(false);
                Statement stat = conn.createStatement();
                String tableName = type;
                stat.executeUpdate("create table if not exists " + tableName + " (id text PRIMARY KEY, xml text);");
                stat.execute("DELETE FROM " + tableName + " where id = '" + id + "';");
                stat.executeUpdate("INSERT INTO " + tableName + " values ('" + id + "', " + "'" + content + "');");
                conn.commit();
                conn.setAutoCommit(true);
                Object var9_9 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    break block12;
                }
                catch (SQLException a_e) {
                    LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                }
                break block12;
                {
                    catch (SQLException a_e) {
                        throw new EDBException("EXception in insert(): " + a_e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException a_e) {
                        LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Vector getAllTypes() throws EDBException {
        Object object = this.SYNC_EXTERNAL_DATABASE;
        synchronized (object) {
            Vector<String> vec;
            block13: {
                Connection conn = null;
                vec = new Vector<String>();
                conn = DriverManager.getConnection(this.m_dbConf.getDatabaseURL());
                conn.setAutoCommit(false);
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select name from sqlite_master where type = 'table';");
                while (rs.next()) {
                    vec.addElement(rs.getString("name"));
                }
                rs.close();
                Object var7_7 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    break block13;
                }
                catch (SQLException a_e) {
                    LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                }
                break block13;
                {
                    catch (SQLException a_e) {
                        throw new EDBException("Exception in getAllTypes(): " + a_e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException a_e) {
                        LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                    }
                    throw throwable;
                }
            }
            return vec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Vector getAllValuesOfType(String type) throws EDBException {
        Object object = this.SYNC_EXTERNAL_DATABASE;
        synchronized (object) {
            Vector<String> vec;
            block13: {
                Connection conn = null;
                vec = new Vector<String>();
                conn = DriverManager.getConnection(this.m_dbConf.getDatabaseURL());
                conn.setAutoCommit(false);
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select xml from " + type + ";");
                while (rs.next()) {
                    vec.addElement(rs.getString("xml"));
                }
                rs.close();
                Object var8_8 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    break block13;
                }
                catch (SQLException a_e) {
                    LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                }
                break block13;
                {
                    catch (SQLException a_e) {
                        throw new EDBException("Exception in getAllTypes(): " + a_e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException a_e) {
                        LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                    }
                    throw throwable;
                }
            }
            return vec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void removeType(String type) throws EDBException {
        Object object = this.SYNC_EXTERNAL_DATABASE;
        synchronized (object) {
            block12: {
                Connection conn = null;
                conn = DriverManager.getConnection(this.m_dbConf.getDatabaseURL());
                conn.setAutoCommit(false);
                Statement stat = conn.createStatement();
                stat.executeUpdate("drop table " + type + ";");
                conn.commit();
                conn.setAutoCommit(true);
                Object var6_6 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    break block12;
                }
                catch (SQLException a_e) {
                    LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                }
                break block12;
                {
                    catch (SQLException a_e) {
                        throw new EDBException("Exception in removeType(): " + a_e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException a_e) {
                        LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void remove(String type, String key) throws EDBException {
        Object object = this.SYNC_EXTERNAL_DATABASE;
        synchronized (object) {
            block12: {
                Connection conn = null;
                conn = DriverManager.getConnection(this.m_dbConf.getDatabaseURL());
                conn.setAutoCommit(false);
                Statement stat = conn.createStatement();
                stat.executeUpdate("delete from " + type + " where id = ('" + key + "');");
                conn.commit();
                conn.setAutoCommit(true);
                Object var7_7 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    break block12;
                }
                catch (SQLException a_e) {
                    LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                }
                break block12;
                {
                    catch (SQLException a_e) {
                        throw new EDBException("EXception in insert(): " + a_e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException a_e) {
                        LogHolder.log(2, LogType.DB, "Could not close database!", a_e);
                    }
                    throw throwable;
                }
            }
        }
    }
}

