/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.crypto.AbstractX509AlternativeName;
import anon.crypto.AbstractX509Extension;
import anon.crypto.JAPCertificate;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509SubjectAlternativeName;
import anon.util.Util;
import anon.util.XMLUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceLocation {
    public static final String XML_ELEMENT_NAME = "Location";
    public static final String XML_ELEMENT_CITY = "City";
    public static final String XML_ELEMENT_STATE = "State";
    public static final String XML_ELEMENT_COUNTRY = "Country";
    public static final String XML_ELEMENT_POSITION = "Position";
    public static final String XML_ELEMENT_GEO = "Geo";
    public static final String XML_ELEMENT_LONGITUDE = "Longitude";
    public static final String XML_ELEMENT_LATITUDE = "Latitude";
    private String city;
    private String state;
    private String m_country;
    private String m_commonName;
    private String longitude;
    private String latitude;

    public ServiceLocation(Node locationNode, JAPCertificate mixCertificate) {
        Node node;
        if (mixCertificate != null) {
            Vector coordinates;
            X509SubjectAlternativeName alternativeName;
            X509DistinguishedName subject = mixCertificate.getSubject();
            this.city = subject.getLocalityName();
            this.state = subject.getStateOrProvince();
            this.m_country = subject.getCountryCode();
            this.m_commonName = subject.getCommonName();
            AbstractX509Extension extension = mixCertificate.getExtensions().getExtension(X509SubjectAlternativeName.IDENTIFIER);
            if (extension != null && extension instanceof X509SubjectAlternativeName && (alternativeName = (X509SubjectAlternativeName)extension).getTags().size() == 2 && alternativeName.getValues().size() == 2 && (coordinates = alternativeName.getTags()).elementAt(0).equals(AbstractX509AlternativeName.TAG_OTHER) && coordinates.elementAt(1).equals(AbstractX509AlternativeName.TAG_OTHER)) {
                coordinates = alternativeName.getValues();
                try {
                    this.longitude = coordinates.elementAt(0).toString();
                    Util.parseDouble(this.longitude);
                    this.longitude = this.longitude.trim();
                }
                catch (NumberFormatException a_e) {
                    this.longitude = "";
                }
                try {
                    this.latitude = coordinates.elementAt(1).toString();
                    Util.parseDouble(this.latitude);
                    this.latitude = this.latitude.trim();
                }
                catch (NumberFormatException a_e) {
                    this.latitude = "";
                }
            }
        }
        if (this.city == null || this.city.trim().length() == 0) {
            node = XMLUtil.getFirstChildByName(locationNode, XML_ELEMENT_CITY);
            this.city = XMLUtil.parseValue(node, "");
        }
        if (this.state == null || this.state.trim().length() == 0) {
            node = XMLUtil.getFirstChildByName(locationNode, XML_ELEMENT_STATE);
            this.state = XMLUtil.parseValue(node, "");
        }
        if (this.m_country == null || this.m_country.trim().length() == 0) {
            node = XMLUtil.getFirstChildByName(locationNode, XML_ELEMENT_COUNTRY);
            this.m_country = XMLUtil.parseValue(node, "");
        }
        Node positionNode = XMLUtil.getFirstChildByName(locationNode, XML_ELEMENT_POSITION);
        positionNode = XMLUtil.getFirstChildByName(positionNode, XML_ELEMENT_GEO);
        if (this.longitude == null || this.longitude.trim().length() == 0) {
            node = XMLUtil.getFirstChildByName(positionNode, XML_ELEMENT_LONGITUDE);
            this.longitude = XMLUtil.parseValue(node, "");
        }
        if (this.latitude == null || this.latitude.trim().length() == 0) {
            node = XMLUtil.getFirstChildByName(positionNode, XML_ELEMENT_LATITUDE);
            this.latitude = XMLUtil.parseValue(node, "");
        }
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getCountryCode() {
        return this.m_country;
    }

    public String getCommonName() {
        return this.m_commonName;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public Element toXMLElement(Document ownerDocument) {
        if (ownerDocument == null) {
            return null;
        }
        Element locationElement = ownerDocument.createElement(XML_ELEMENT_NAME);
        if (this.city != null) {
            XMLUtil.createChildElementWithValue(locationElement, XML_ELEMENT_CITY, XMLUtil.filterXMLChars(this.city));
        }
        if (this.state != null) {
            XMLUtil.createChildElementWithValue(locationElement, XML_ELEMENT_STATE, XMLUtil.filterXMLChars(this.state));
        }
        if (this.m_country != null) {
            XMLUtil.createChildElementWithValue(locationElement, XML_ELEMENT_COUNTRY, XMLUtil.filterXMLChars(this.m_country));
        }
        if (this.longitude != null && this.latitude != null) {
            Element positionElement = XMLUtil.createChildElement(locationElement, XML_ELEMENT_POSITION);
            Element geoElement = XMLUtil.createChildElement(positionElement, XML_ELEMENT_GEO);
            XMLUtil.createChildElementWithValue(geoElement, XML_ELEMENT_LONGITUDE, XMLUtil.filterXMLChars(this.longitude));
            XMLUtil.createChildElementWithValue(geoElement, XML_ELEMENT_LATITUDE, XMLUtil.filterXMLChars(this.latitude));
        }
        return locationElement;
    }
}

