/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.infoservice.AbstractDistributableDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.JavaVersionDBEntry;
import anon.util.XMLUtil;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAPVersionInfo
extends AbstractDistributableDatabaseEntry {
    public static final String ID_BETA = "/japDevelopment.jnlp";
    public static final String ID_STABLE = "/japRelease.jnlp";
    public static final int JAP_RELEASE_VERSION = 1;
    public static final int JAP_DEVELOPMENT_VERSION = 2;
    private static final long DATABASE_TIMEOUT = Long.MAX_VALUE;
    private int m_versionInfoType;
    private String m_version;
    private Date m_releaseDate;
    private String m_jarFileName;
    private URL[] m_codeBase;
    private Boolean[] m_bIncrementalAllowed;
    private String m_lastSupportedJavaVersion;
    private long m_lastUpdate;
    private Element m_xmlStructure;
    static /* synthetic */ Class class$anon$infoservice$JAPVersionInfo;

    public static String getXmlElementName() {
        return "jnlp";
    }

    public JAPVersionInfo(Element a_jnlpRootNode, int a_versionInfoType) throws Exception {
        super(Long.MAX_VALUE);
        int indexPlus;
        this.m_versionInfoType = a_versionInfoType;
        this.m_version = XMLUtil.parseAttribute((Node)a_jnlpRootNode, "version", "");
        this.m_version = this.m_version.trim();
        try {
            String strDate = a_jnlpRootNode.getAttribute("releaseDate") + " GMT";
            try {
                this.m_releaseDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z").parse(strDate);
            }
            catch (ParseException a_e) {
                this.m_releaseDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").parse(strDate);
            }
        }
        catch (Exception e) {
            this.m_releaseDate = null;
        }
        Vector<URL> vCodeBases = new Vector<URL>();
        Vector<Boolean> vIncremental = new Vector<Boolean>();
        vCodeBases.addElement(new URL(a_jnlpRootNode.getAttribute("codebase")));
        vIncremental.addElement(new Boolean(true));
        Element nodeResources = (Element)XMLUtil.getFirstChildByName(a_jnlpRootNode, "resources");
        NodeList nlJars = nodeResources.getElementsByTagName("jar");
        for (int i = 0; i < nlJars.getLength(); ++i) {
            try {
                Element elemJar = (Element)nlJars.item(i);
                String part = elemJar.getAttribute("part");
                if (!part.equals("jap")) continue;
                this.m_jarFileName = elemJar.getAttribute("href");
                Node elemCodeBases = XMLUtil.getFirstChildByName(elemJar, "codebases");
                if (elemCodeBases == null) break;
                Node elemCodeBase = XMLUtil.getFirstChildByName(elemCodeBases, "codebase");
                while (elemCodeBase != null) {
                    try {
                        URL url = new URL(XMLUtil.parseValue(elemCodeBase, null));
                        Boolean bIncrementalAllowed = new Boolean(XMLUtil.parseAttribute(elemCodeBase, "incremental", true));
                        if (vCodeBases.contains(url)) {
                            vIncremental.removeElementAt(vCodeBases.indexOf(url));
                            vCodeBases.removeElement(url);
                        }
                        vCodeBases.addElement(url);
                        vIncremental.addElement(bIncrementalAllowed);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    elemCodeBase = XMLUtil.getNextSiblingByName(elemCodeBase, "codebase");
                }
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.m_codeBase = new URL[vCodeBases.size()];
        this.m_bIncrementalAllowed = new Boolean[vIncremental.size()];
        vCodeBases.copyInto(this.m_codeBase);
        vIncremental.copyInto(this.m_bIncrementalAllowed);
        NodeList listJ2se = XMLUtil.getElementsByTagName(nodeResources, "j2se");
        this.m_lastSupportedJavaVersion = JavaVersionDBEntry.CURRENT_JAVA_VERSION;
        if (listJ2se != null) {
            for (int i = 0; i < listJ2se.getLength(); ++i) {
                String verTemp = XMLUtil.parseAttribute(listJ2se.item(i), "version", JavaVersionDBEntry.CURRENT_JAVA_VERSION);
                if (this.m_lastSupportedJavaVersion.compareTo(verTemp) <= 0) continue;
                this.m_lastSupportedJavaVersion = verTemp;
            }
        }
        if ((indexPlus = this.m_lastSupportedJavaVersion.indexOf("+")) > 0) {
            this.m_lastSupportedJavaVersion = this.m_lastSupportedJavaVersion.substring(0, indexPlus);
        }
        this.m_lastUpdate = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_jnlpRootNode, "LastUpdate"), -1L);
        if (this.m_lastUpdate == -1L) {
            this.m_lastUpdate = System.currentTimeMillis();
        }
        this.m_xmlStructure = a_jnlpRootNode;
    }

    public static JAPVersionInfo getRecommendedUpdate(String a_currentVersion, boolean a_bStable) {
        JAPVersionInfo viStable = (JAPVersionInfo)Database.getInstance(class$anon$infoservice$JAPVersionInfo == null ? (class$anon$infoservice$JAPVersionInfo = JAPVersionInfo.class$("anon.infoservice.JAPVersionInfo")) : class$anon$infoservice$JAPVersionInfo).getEntryById(ID_STABLE);
        JAPVersionInfo viBeta = (JAPVersionInfo)Database.getInstance(class$anon$infoservice$JAPVersionInfo == null ? (class$anon$infoservice$JAPVersionInfo = JAPVersionInfo.class$("anon.infoservice.JAPVersionInfo")) : class$anon$infoservice$JAPVersionInfo).getEntryById(ID_BETA);
        if (a_bStable) {
            if (viStable != null && viStable.getJapVersion().compareTo(a_currentVersion) > 0) {
                return viStable;
            }
            return null;
        }
        if (viStable != null) {
            if (viBeta == null && viStable.getJapVersion().compareTo(a_currentVersion) > 0) {
                return viStable;
            }
            if (viBeta != null && viStable.getJapVersion().compareTo(a_currentVersion) > 0 && viBeta.getJapVersion().compareTo(a_currentVersion) > 0) {
                return viStable;
            }
        }
        if (viBeta != null && viBeta.getJapVersion().compareTo(a_currentVersion) > 0) {
            return viBeta;
        }
        return null;
    }

    public boolean isJavaVersionStillSupported() {
        return JavaVersionDBEntry.CURRENT_JAVA_VERSION.compareTo(this.m_lastSupportedJavaVersion) >= 0;
    }

    public String getSupportedJavaVersion() {
        return this.m_lastSupportedJavaVersion;
    }

    public String getId() {
        String versionInfoId = ID_STABLE;
        if (this.m_versionInfoType == 2) {
            versionInfoId = ID_BETA;
        }
        return versionInfoId;
    }

    public long getVersionNumber() {
        return this.m_lastUpdate;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public String getJapVersion() {
        return this.m_version;
    }

    public Date getDate() {
        return this.m_releaseDate;
    }

    public URL[] getCodeBase() {
        URL[] codeBase = new URL[this.m_codeBase.length];
        System.arraycopy(this.m_codeBase, 0, codeBase, 0, this.m_codeBase.length);
        return codeBase;
    }

    public boolean isIncrementalAllowed(int a_source) {
        return this.m_bIncrementalAllowed[a_source];
    }

    public String getJAPJarFileName() {
        return this.m_jarFileName;
    }

    public String getPostFile() {
        return this.getId();
    }

    public Element getXmlStructure() {
        return this.m_xmlStructure;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

