/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509Extension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.ReasonFlags;

public class X509IssuingDistributionPoint
extends AbstractX509Extension {
    public static final String IDENTIFIER = Extension.issuingDistributionPoint.getId();
    private IssuingDistributionPoint m_issuingDistributionPoint;

    public X509IssuingDistributionPoint(DistributionPointName distributionPoint, boolean onlyContainsUserCerts, boolean onlyContainsCACerts, ReasonFlags onlySomeReasons, boolean indirectCRL, boolean onlyContainsAttributeCerts) {
        super(IDENTIFIER, false, X509IssuingDistributionPoint.createDEROctets(distributionPoint, !onlyContainsUserCerts, !onlyContainsCACerts, onlySomeReasons, !indirectCRL, !onlyContainsAttributeCerts));
        this.m_issuingDistributionPoint = IssuingDistributionPoint.getInstance(X509IssuingDistributionPoint.createDERObject(distributionPoint, !onlyContainsUserCerts, !onlyContainsCACerts, onlySomeReasons, !indirectCRL, !onlyContainsAttributeCerts));
    }

    public X509IssuingDistributionPoint(boolean a_indirectCRL) {
        this(null, false, false, null, a_indirectCRL, false);
    }

    public X509IssuingDistributionPoint(ASN1Sequence a_extension) {
        super(a_extension);
        this.createValue();
    }

    private void createValue() {
        try {
            ASN1InputStream ais = new ASN1InputStream(new ByteArrayInputStream(this.getDEROctets()));
            this.m_issuingDistributionPoint = IssuingDistributionPoint.getInstance((DERSequence)ais.readObject());
            ais.close();
        }
        catch (Exception a_e) {
            throw new RuntimeException("Could not read issuing distribution point extension from byte array!");
        }
    }

    private static byte[] createDEROctets(DistributionPointName distributionPoint, boolean onlyContainsUserCerts, boolean onlyContainsCACerts, ReasonFlags onlySomeReasons, boolean indirectCRL, boolean onlyContainsAttributeCerts) {
        try {
            return X509IssuingDistributionPoint.createDERObject(distributionPoint, onlyContainsUserCerts, onlyContainsCACerts, onlySomeReasons, indirectCRL, onlyContainsAttributeCerts).getEncoded("DER");
        }
        catch (IOException e) {
            return null;
        }
    }

    private static DERSequence createDERObject(DistributionPointName distributionPoint, boolean onlyContainsUserCerts, boolean onlyContainsCACerts, ReasonFlags onlySomeReasons, boolean indirectCRL, boolean onlyContainsAttributeCerts) {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        if (distributionPoint != null) {
            vec.add(new DERTaggedObject(true, 0, distributionPoint));
        }
        if (onlyContainsUserCerts) {
            vec.add(new DERTaggedObject(false, 1, ASN1Boolean.TRUE));
        }
        if (onlyContainsCACerts) {
            vec.add(new DERTaggedObject(false, 2, ASN1Boolean.TRUE));
        }
        if (onlySomeReasons != null) {
            vec.add(new DERTaggedObject(false, 3, onlySomeReasons));
        }
        if (indirectCRL) {
            vec.add(new DERTaggedObject(false, 4, ASN1Boolean.TRUE));
        }
        if (onlyContainsAttributeCerts) {
            vec.add(new DERTaggedObject(false, 5, ASN1Boolean.TRUE));
        }
        return new DERSequence(vec);
    }

    public String getName() {
        return "IssuingDistributionPoint";
    }

    public Vector getValues() {
        return null;
    }

    public boolean isIndirectCRL() {
        return this.m_issuingDistributionPoint.isIndirectCRL();
    }

    public IssuingDistributionPoint getIssuingDistributionPoint() {
        return this.m_issuingDistributionPoint;
    }
}

