/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.IMyPublicKey;
import anon.crypto.MyX509Extensions;
import anon.crypto.X509DistinguishedName;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

final class CertificationRequestInfo
extends DERSequence {
    private IMyPublicKey m_publicKey;
    private X509DistinguishedName m_subject;
    private MyX509Extensions m_extensions;

    public CertificationRequestInfo(X509DistinguishedName a_subject, IMyPublicKey a_publicKey, MyX509Extensions a_extensions) {
        super(CertificationRequestInfo.createRequestInfo(new ASN1Integer(0L), a_subject.getX500Name(), a_publicKey.getAsSubjectPublicKeyInfo(), a_extensions));
        this.m_subject = a_subject;
        try {
            this.m_publicKey = AsymmetricCryptoKeyPair.createPublicKey(a_publicKey.getAsSubjectPublicKeyInfo());
        }
        catch (Exception a_e) {
            throw new RuntimeException("Could not create public key: " + a_e.getMessage());
        }
        this.m_extensions = a_extensions;
    }

    CertificationRequestInfo(ASN1Sequence a_sequence) {
        super(CertificationRequestInfo.createRequestInfo(a_sequence));
        try {
            this.m_publicKey = AsymmetricCryptoKeyPair.createPublicKey(SubjectPublicKeyInfo.getInstance(a_sequence.getObjectAt(2)));
        }
        catch (Exception a_e) {
            throw new RuntimeException("Could not create public key: " + a_e.getMessage());
        }
        this.m_subject = new X509DistinguishedName(X500Name.getInstance(this.getObjectAt(1)));
        ASN1Primitive temp = null;
        if (this.size() > 3) {
            temp = ((DERTaggedObject)this.getObjectAt(3)).getObject();
        }
        this.m_extensions = temp instanceof DERSet ? new MyX509Extensions((DERSet)temp) : new MyX509Extensions(new DERSet());
    }

    public IMyPublicKey getPublicKey() {
        return this.m_publicKey;
    }

    public MyX509Extensions getExtensions() {
        return this.m_extensions;
    }

    public X509DistinguishedName getX509DistinguishedName() {
        return this.m_subject;
    }

    private static ASN1EncodableVector createRequestInfo(ASN1Integer a_version, X500Name a_subject, SubjectPublicKeyInfo a_subjectPublicKeyInfo, MyX509Extensions a_extensions) {
        ASN1Set setExtensions;
        ASN1EncodableVector certificateRequestInfo = new ASN1EncodableVector();
        certificateRequestInfo.add(a_version);
        certificateRequestInfo.add(a_subject);
        certificateRequestInfo.add(a_subjectPublicKeyInfo);
        if (a_extensions != null && a_extensions.getSize() > 0 && (setExtensions = a_extensions.getExtensionsAsASN1Set()) != null) {
            DERTaggedObject derObject = new DERTaggedObject(false, 0, setExtensions);
            certificateRequestInfo.add(derObject);
        }
        return certificateRequestInfo;
    }

    private static ASN1EncodableVector createRequestInfo(ASN1Sequence a_sequence) {
        ASN1Integer version = (ASN1Integer)a_sequence.getObjectAt(0);
        X500Name x500Name = X500Name.getInstance(a_sequence.getObjectAt(1));
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(a_sequence.getObjectAt(2));
        MyX509Extensions extensions = null;
        if (a_sequence.size() > 3) {
            extensions = new MyX509Extensions(ASN1Set.getInstance((ASN1TaggedObject)a_sequence.getObjectAt(3), false));
        }
        return CertificationRequestInfo.createRequestInfo(version, x500Name, subjectPublicKeyInfo, extensions);
    }
}

