/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import anon.client.MixParameters;
import anon.client.crypto.IMixCipher;
import anon.client.crypto.ISymCipher;
import anon.client.replay.ReplayTimestamp;
import java.util.Vector;

public class DefaultMixCipher
implements IMixCipher {
    private boolean m_firstEncryptionPacket = true;
    private MixParameters m_mixParameters;
    private ISymCipher m_symCipher;

    public DefaultMixCipher(MixParameters a_mixParameters, ISymCipher a_symCipher) {
        this.m_mixParameters = a_mixParameters;
        this.m_symCipher = a_symCipher;
    }

    public byte[] encrypt(byte[] a_packet, int a_virtualPacketLength, Vector a_sendCallbackHandlers) {
        int alreadyEncryptedBytes = 0;
        int alreadyOutputBytes = 0;
        int realPacketLength = a_packet.length;
        byte[] payload = null;
        byte[] encryptedPacket = null;
        if (this.m_firstEncryptionPacket) {
            ReplayTimestamp timestampStructure;
            payload = a_virtualPacketLength > (realPacketLength += this.getNextPacketEncryptionOverhead()) ? new byte[a_virtualPacketLength] : new byte[realPacketLength];
            byte[] symmetricKey = this.m_symCipher.getKeys();
            symmetricKey[0] = (byte)(symmetricKey[0] & 0x7F);
            int diff = (int)(System.currentTimeMillis() / 1000L - MixParameters.m_referenceTime);
            byte[] ReplayOffset = this.m_mixParameters.getCurrentReplayOffset(diff);
            if (ReplayOffset != null) {
                for (int i = 0; i < ReplayOffset.length; ++i) {
                    symmetricKey[symmetricKey.length - ReplayOffset.length + i] = ReplayOffset[i];
                }
            }
            if ((timestampStructure = this.m_mixParameters.getReplayTimestamp()) != null) {
                byte[] currentTimestamp = timestampStructure.getCurrentTimestamp();
                System.arraycopy(currentTimestamp, 0, symmetricKey, symmetricKey.length - currentTimestamp.length, currentTimestamp.length);
            }
            this.m_symCipher.setEncryptionKeysAES(symmetricKey);
            System.arraycopy(this.m_symCipher.getKeys(), 0, payload, 0, this.m_symCipher.getKeys().length);
            System.arraycopy(a_packet, 0, payload, this.m_symCipher.getKeys().length, a_packet.length);
            encryptedPacket = new byte[payload.length];
            this.m_mixParameters.getMixCipher().encrypt(payload, 0, encryptedPacket, 0);
            alreadyEncryptedBytes = this.m_mixParameters.getMixCipher().getInputBlockSize();
            alreadyOutputBytes = this.m_mixParameters.getMixCipher().getOutputBlockSize();
            this.m_firstEncryptionPacket = false;
        } else {
            payload = a_virtualPacketLength > realPacketLength ? new byte[a_virtualPacketLength] : new byte[realPacketLength];
            System.arraycopy(a_packet, 0, payload, 0, a_packet.length);
            encryptedPacket = new byte[payload.length];
        }
        this.m_symCipher.encryptAES1(payload, alreadyEncryptedBytes, encryptedPacket, alreadyOutputBytes, payload.length - alreadyOutputBytes);
        if (realPacketLength < encryptedPacket.length) {
            byte[] tempPacket = encryptedPacket;
            encryptedPacket = new byte[realPacketLength];
            System.arraycopy(tempPacket, 0, encryptedPacket, 0, realPacketLength);
        }
        return encryptedPacket;
    }

    public boolean decrypt(byte[] a_packet) {
        this.m_symCipher.encryptAES2(a_packet);
        return true;
    }

    public int getNextPacketEncryptionOverhead() {
        int overhead = 0;
        if (this.m_firstEncryptionPacket) {
            overhead = this.m_symCipher.getKeys().length + this.m_mixParameters.getMixCipher().getPaddingSize();
        }
        return overhead;
    }
}

